﻿<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" Theme="Voxco" Inherits="Voxco.Reporting.DefaultPage" Title="<%$ Resources:Resource, VoxcoReporting%>" Codebehind="Default.aspx.cs" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Src="~/WaitingPanel.ascx" TagPrefix="VxRpt" TagName="WaitingPanel" %>

<asp:Content ID="Content1" ContentPlaceHolderID="MainContent" runat="Server">
    
    <telerik:RadScriptBlock ID="test" runat="server">
    <script type="text/javascript" id="DefaultScriptFL">
        $(document).ready(function(){
            // Reporting's default page should never be the the top window, it should alsays be viewed inside VIC
            if( top.window.location == window.location )
            {
                window.location = "<%= GetVICBaseUrl() %>";
            }
        });
	        	        
        if (Telerik.Web.UI.RadTreeView != undefined) {
            Telerik.Web.UI.RadTreeView.prototype.saveClientState = function () {
                return "{\"expandedNodes\":" + this._expandedNodesJson +
                    ",\"collapsedNodes\":" + this._collapsedNodesJson +
                    ",\"logEntries\":" + this._logEntriesJson +
                    ",\"selectedNodes\":" + this._selectedNodesJson +
                    ",\"checkedNodes\":" + this._checkedNodesJson +
                    ",\"scrollPosition\":" + Math.round(this._scrollPosition) + "}";
            }
        }
        
        function ReportToolbar_ClickButton(sender, e)
        {
            var _grid = <%= grdReportList.ClientID %>; 
            if( _grid.MasterTableView.GetSelectedRowsIndexes() == "")
            {
                alert("<%= GetSelectionErrorMessage() %>");
                return false;
            }
                
            if (sender.CommandName == "DeleteReport")
            {
                if (!confirm("<%= GetDeleteConfirmationMessage() %>"))
                {
                    return false;
                }
            }
            
            return true;
        }
        
        function RebingGroupTreeView()
        {
            var tree = <%= ReportGroupTreeView.ClientID%>;
            tree.UnSelectAllNodes();
        }
        
        function RefreshReportButton_Click()
        {            
            $find("<%= PageAjaxPanel.ClientID %>").ajaxRequest("RefreshReport");
        }
		
		var oldNode =null;
        function ReportGroupTreeView_NodeClick(sender, eventArgs)
        {
			var _newNode = eventArgs.get_node(); 
			if (oldNode == null)
			{
				$find("<%= PageAjaxPanel.ClientID %>").ajaxRequest("NodeClick:"+_newNode.get_value());
				oldNode = _newNode;
			}
			else if (_newNode.get_value() != oldNode.get_value()) 
			{				
				$find("<%= PageAjaxPanel.ClientID %>").ajaxRequest("NodeClick:"+_newNode.get_value());
				oldNode = _newNode;
			}	
        }

		function DownloadReport(url)
        {     						
			$('.xlsPopUp').attr('src', url);			
            //window["DownloadReportFrame"].location = url; 
        }
        
       
        
        /* Methods called from VIC  */
        
        function VIC_CheckedSelectedRow()
        {
			var _response = "False";
			var _grid = $find('<%= grdReportList.ClientID %>'); 
            var _masterTableView = _grid.get_masterTableView();
            var _selectedItems = _masterTableView.get_selectedItems();
            if( _selectedItems == "")
            {
				alert("<%= GetSelectionErrorMessage() %>");
				return _response;
            }
            else
            {
				_response = "True";
				return _response;
            }
        }
        
        function VIC_Prompt_DeleteSelected()
        {
            var _return = VIC_CheckedSelectedRow();
			if(_return == "True")
			{
				if (confirm("<%= GetDeleteConfirmationMessage() %>"))
				{
					$find("<%= PageAjaxPanel.ClientID %>").ajaxRequestWithTarget("<%= PageAjaxPanel.UniqueID %>", "DeleteReport");
				}
			}
        }
        
        function VIC_OpenSelected()
        {
            var _return = VIC_CheckedSelectedRow();
			if(_return == "True")
			{
				$find("<%= PageAjaxPanel.ClientID %>").ajaxRequestWithTarget("<%= PageAjaxPanel.UniqueID %>", "OpenReport");
			}
        }
        
        function VIC_DisplaySelected()
        {
			var _return = VIC_CheckedSelectedRow();
			if(_return == "True")
			{				
				$find("<%= PageAjaxPanel.ClientID %>").ajaxRequestWithTarget("<%= PageAjaxPanel.UniqueID %>", "DisplayReport");
			}
        }
        
        function VIC_ExportSelected()
        {
            var _return = VIC_CheckedSelectedRow();
			if(_return == "True")
			{
				$find("<%= PageAjaxPanel.ClientID %>").ajaxRequestWithTarget("<%= PageAjaxPanel.UniqueID %>", "DisplayExcel");
			}
        }
        
        function VIC_RenameSelected()
        {
            var _return = VIC_CheckedSelectedRow();
			if(_return == "True")
			{
				$find("<%= PageAjaxPanel.ClientID %>").ajaxRequestWithTarget("<%= PageAjaxPanel.UniqueID %>", "EditSelected");
			}
        }
        
        
        function VIC_AddFolder()
        {
            $find("<%= PageAjaxPanel.ClientID %>").ajaxRequestWithTarget("<%= PageAjaxPanel.UniqueID %>", "NewGroup");
        }
        
        function VIC_AddTopFolder()
        {
            $find("<%= PageAjaxPanel.ClientID %>").ajaxRequestWithTarget("<%= PageAjaxPanel.UniqueID %>", "NewTopGroup");
        }
        
        function VIC_DeleteFolder()
        {
            if (confirm("<%= GetDeleteConfirmationMessage() %>"))
            {
                $find("<%= PageAjaxPanel.ClientID %>").ajaxRequestWithTarget("<%= PageAjaxPanel.UniqueID %>", "DeleteGroup");
            }
        }
        
        function VIC_Update()
        {
            $find("<%= PageAjaxPanel.ClientID %>").ajaxRequestWithTarget("<%= PageAjaxPanel.UniqueID %>", "UpdateEdited");
        }
        
        function VIC_Cancel()
        {
             $find("<%= PageAjaxPanel.ClientID %>").ajaxRequestWithTarget("<%= PageAjaxPanel.UniqueID %>", "CancelAll");
        }
        
        function onResponseReceived(sender, arguments)
        {
            if (strStartsWith(arguments.EventArgument,'NodeClick:'))
            {
                DisplayMenuItems()
            } 
        }
        
        function strStartsWith(str, prefix) {
                return str.indexOf(prefix) == 0;
        }        
        
        
        var canClick =true;
        function ReportGroupTreeView_NodeClicking(sender, eventArgs)
        {
            if (canClick==false)
            {
                eventArgs.set_cancel(true);
                canClick =true;
            }
   		}    
 
       
   		function ReportGroupTreeView_NodeEdited(sender, eventArgs)
        {
            canClick=false;
 
   		}
   		
        function CanClickTree()
        {
            canClick = true;;
 
   		}
        /****************************/
        
    </script>
    </telerik:RadScriptBlock>  
    
    <asp:ObjectDataSource ID="ReportDataSource" runat="server" SelectMethod="GetFolderReports" UpdateMethod="Update" TypeName="Voxco.Reporting.DataSource.Reports">
        <SelectParameters>
            <asp:SessionParameter SessionField="CurrentGroupId" DefaultValue="0" Type="Int32" Name="_folderId" />
        </SelectParameters>
        <UpdateParameters>
            <asp:Parameter Name="ReportId" Type="Int32" />
            <asp:Parameter Name="ReportName" Type="String" />
            <asp:Parameter Name="ReportDescription" Type="String" />
        </UpdateParameters>
    </asp:ObjectDataSource>
    
    <asp:ObjectDataSource ID="ReportGroupDataSource" runat="server" SelectMethod="Get"
        TypeName="Voxco.Reporting.DataSource.ReportGroups" InsertMethod="Insert">
        <InsertParameters>
            <asp:Parameter Name="_name" Type="String" />
            <asp:Parameter Name="_parentId" Type="Int32" />
        </InsertParameters>
    </asp:ObjectDataSource>
    
    <telerik:RadAjaxLoadingPanel ID="MainAjaxLoadingPanel" runat="server" Transparency="20">
        <VxRpt:WaitingPanel id="WaitingPanel" runat="server" />
    </telerik:RadAjaxLoadingPanel>
    
    <telerik:RadWindowManager ID="RadWindowManager1" runat="server">
    </telerik:RadWindowManager>
     
    <telerik:RadAjaxPanel ID="PageAjaxPanel" runat="server" EnableAJAX="true" Width="100%" LoadingPanelID="MainAjaxLoadingPanel" OnAjaxRequest="PageAjaxPanel_OnAjaxRequest" ClientEvents-OnResponseEnd="onResponseReceived">
	
		<div style="float: left; width: 20%; overflow:auto; border: 1px solid #828282;">

                <telerik:RadTreeView ID="ReportGroupTreeView" AllowNodeEditing="True"
					runat="server" DataSourceID="ReportGroupDataSource" DataFieldID="ReportGroupId"
                    DataFieldParentID="OwnerGroupId" DataValueField="ReportGroupId" DataTextField="ReportGroupName"                    
                    MultipleSelect="false" Height="400px"               
                    OnDataBound="ReportGroupTreeView_DataBound"  OnClientNodeEdited="ReportGroupTreeView_NodeEdited"  OnClientNodeClicking="ReportGroupTreeView_NodeClicking"  OnClientNodeClicked="ReportGroupTreeView_NodeClick"
                    OnNodeEdit="HandleNodeEdit"  OnNodeDataBound="ReportGroupTreeView_NodeBound">
                    <DataBindings>
                        <telerik:RadTreeNodeBinding ExpandedImageUrl="~/icons/folder.png" ImageUrl="~/icons/folder_closed.png"
                            TextField="ReportGroupName" ValueField="ReportGroupId" />
                    </DataBindings>
                </telerik:RadTreeView>
                
		</div>
        
        <div style="width: 75%; float:left; margin-left: 25px;">
            
            <telerik:RadGrid ID="grdReportList" runat="server" AllowSorting="True" 
            SortingSettings-SortToolTip="<%$ Resources:Resource, SortingHeader%>" 
            SortingSettings-SortedAscToolTip="<%$ Resources:Resource, SortingHeader%>" 
            SortingSettings-SortedDescToolTip="<%$ Resources:Resource, SortingHeader%>" 
            OnItemDataBound="grdReportList_ItemDataBound" OnSortCommand="grdReportList_OnSortCommand" OnDataBound="grdReportList_DataBound"  
            AllowAutomaticUpdates="True" AllowMultiRowSelection="true" AllowMultiRowEdit="true" 
            OnItemCreated="grdReportList_ItemCreated" DataSourceID="ReportDataSource" Height="400px" 
            EnableEmbeddedBaseStylesheet="false" EnableEmbeddedSkins="false" Skin="Voxco" ClientSettings-EnableRowHoverStyle="true">
                    <MasterTableView DataSourceID="ReportDataSource" AutoGenerateColumns="False" NoMasterRecordsText="" CommandItemDisplay="Top" EditMode="InPlace" Width="100%">
                        <SortExpressions>
                            <telerik:GridSortExpression FieldName="ReportName" />
                        </SortExpressions>
                        <CommandItemTemplate>
                            <table style="width: 100%; display:none;">
                                <tr>
                                    <td>
                                    <telerik:RadToolbar ID="ReportToolbar" AutoPostback="true" runat="server" OnClientButtonClicked="ReportToolbar_ClickButton"
                                        Visible='<%# grdReportList.EditIndexes.Count == 0 && !grdReportList.MasterTableView.IsItemInserted %>'>
                                        <Items>
                                            <telerik:RadToolbarButton runat="server" ImageUrl="~/icons/ico16_report.gif"
                                                ToolTip="<%$ Resources:Resource, DisplayReport %>" CommandName="DisplayReport" Text="<%$ Resources:Resource, DisplayReport %>" />
                                            <telerik:RadToolbarButton runat="server" ImageUrl="~/icons/ico16_excel.gif"
                                                ToolTip="<%$ Resources:Resource, Excel %>" CommandName="DisplayExcel" Text="<%$ Resources:Resource, Excel %>" />
                                            <telerik:RadToolbarButton runat="server" ImageUrl="~/icons/ico16_pageformat.gif" Visible="false"
                                                ToolTip="<%$ Resources:Resource, PDF %>" CommandName="DisplayPdf" Text="<%$ Resources:Resource, PDF %>" />
                                            <telerik:RadToolBarButton runat="server" ImageUrl="~/icons/document_into.png"
                                                ToolTip="<%$ Resources:Resource, Open %>" CommandName="OpenReport" Text="<%$ Resources:Resource, Open %>"/>
                                            <telerik:RadToolBarButton runat="server" ImageUrl="~/icons/document_new.png"
                                                ToolTip="<%$ Resources:Resource, NewReport %>" CommandName="NewReport" Text="<%$ Resources:Resource, NewReport %>" Visible="False" />
                                            <telerik:RadToolbarButton runat="server" ImageUrl="~/icons/ico16_Questionnaire.gif"
                                                ToolTip="<%$ Resources:Resource, NewQPrint %>" CommandName="NewQPrintReport" Text="<%$ Resources:Resource, NewQPrint %>" Visible="False"  />
                                            <telerik:RadToolBarButton runat="server" ImageUrl="~/icons/trash.gif"
                                                ToolTip="<%$ Resources:Resource, Delete %>" CommandName="DeleteReport" Text="<%$ Resources:Resource, Delete %>" />
            <%--                                <radTlb:RadToolBarButton ID="UndeleteButton" runat="server" DisplayType="TextImage" ButtonImage="ico16_restore.gif"
                                                ToolTip="<%$ Resources:Resource, Undelete %>" CommandName="UndeleteReport" ButtonText="<%$ Resources:Resource, Undelete %>" />--%>
                                            <telerik:RadToolbarButton runat="server" ImageUrl="~/icons/edit.gif"
                                                ToolTip="<%$ Resources:Resource, Edit %>" CommandName="EditSelected" Text="<%$ Resources:Resource, Edit %>" />                                            
                                        </Items>
                                    </telerik:RadToolbar>
                                    <telerik:RadToolbar ID="EditToolbar" AutoPostback="true" runat="server" Visible='<%# grdReportList.EditIndexes.Count > 0 %>'>
                                        <Items>
                                            <telerik:RadToolBarButton runat="server" ImageUrl="~/icons/update.gif"
                                                ToolTip="<%$ Resources:Resource, Update %>" CommandName="UpdateEdited" Text="<%$ Resources:Resource, Update %>" />
                                            <telerik:RadToolBarButton runat="server" ImageUrl="~/icons/cancel.gif"
                                                ToolTip="<%$ Resources:Resource, Cancel %>" CommandName="CancelAll" Text="<%$ Resources:Resource, Cancel %>" />
                                        </Items>
                                    </telerik:RadToolbar>
                                        <%--<asp:LinkButton ID="DisplayReportButton" CausesValidation="false" ToolTip="<%$ Resources:Resource, DisplayReport %>"
                                            runat="server" OnClientClick="DisplayReportButton_Click();" Visible='<%# grdReportList.EditIndexes.Count == 0 && !grdReportList.MasterTableView.IsItemInserted %>'>
                                            <img style="border: 0px;" alt="" src="icons/ico16_report.gif" />
                                            <asp:Label ID="Label10" runat="server" Text="<%$ Resources:Resource, DisplayReport %>"></asp:Label>
                                        </asp:LinkButton>
                                        <asp:LinkButton ID="OpenReportButton" CausesValidation="false" ToolTip="<%$ Resources:Resource, Open %>"
                                            runat="server" OnClientClick="OpenReportButton_Click();" Visible='<%# grdReportList.EditIndexes.Count == 0 && !grdReportList.MasterTableView.IsItemInserted %>'>
                                            <img style="border: 0px;" alt="" src="icons/document_into.png" />
                                            <asp:Label ID="Label9" runat="server" Text="<%$ Resources:Resource, Open %>"></asp:Label>
                                        </asp:LinkButton>
                                        <asp:LinkButton ID="AddReportButton" CausesValidation="false" ToolTip="<%$ Resources:Resource, NewReport %>"
                                            runat="server" OnClientClick="AddReportButton_Click();" Visible='<%# grdReportList.EditIndexes.Count == 0 && !grdReportList.MasterTableView.IsItemInserted %>'>
                                            <img style="border: 0px;" alt="" src="icons/document_new.png" />
                                            <asp:Label ID="Label1" runat="server" Text="<%$ Resources:Resource, NewReport %>"></asp:Label>
                                        </asp:LinkButton>
                                        <asp:LinkButton ID="AddQPrintReportButton" CausesValidation="false" ToolTip="<%$ Resources:Resource, NewQPrint %>"
                                            runat="server" OnClientClick="AddQPrintReportButton_Click();" Visible='<%# grdReportList.EditIndexes.Count == 0 && !grdReportList.MasterTableView.IsItemInserted %>'>
                                            <img style="border: 0px;" alt="" src="icons/ico16_Questionnaire.gif" />
                                            <asp:Label ID="Label11" runat="server" Text="<%$ Resources:Resource, NewQPrint %>"></asp:Label>
                                        </asp:LinkButton>
                                        <asp:LinkButton ID="DeleteReportButton" CausesValidation="false" ToolTip="<%$ Resources:Resource, Delete %>"
                                            OnClientClick="DeleteReportButton_Click();" runat="server" Visible='<%# grdReportList.EditIndexes.Count == 0 && !grdReportList.MasterTableView.IsItemInserted %>'>
                                            <img style="border: 0px;" alt="" src="icons/trash.gif" />
                                            <asp:Label ID="Label5" runat="server" Text="<%$ Resources:Resource, Delete %>"></asp:Label>
                                        </asp:LinkButton>
                                        <asp:LinkButton ID="UndeleteButton" CausesValidation="false" ToolTip="Undelete"
                                            OnClientClick="UndeleteReportButton_Click();" runat="server" Visible='<%# UndeleteButtonIsVisible() && grdReportList.EditIndexes.Count == 0 && !grdReportList.MasterTableView.IsItemInserted %>'>
                                            <img style="border: 0px;" alt="" src="icons/ico16_restore.gif" />
                                            <asp:Label ID="Label3" runat="server" Text="<%$ Resources:Resource, Undelete %>"></asp:Label>
                                        </asp:LinkButton>
                                        <asp:LinkButton ID="EditButton"  CommandName="EditSelected" CausesValidation="false" ToolTip="<%$ Resources:Resource, Edit %>"
                                            runat="server" Visible='<%# grdReportList.EditIndexes.Count == 0 && !grdReportList.MasterTableView.IsItemInserted %>'>
                                            <img style="border: 0px;" alt="" src="icons/edit.gif" />
                                            <asp:Label ID="Label4" runat="server" Text="<%$ Resources:Resource, Edit %>"></asp:Label>
                                        </asp:LinkButton>
                                        <asp:LinkButton ID="InsertLinkButton" CommandName="PerformInsert" CausesValidation="false"
                                            Visible='<%# grdReportList.MasterTableView.IsItemInserted %>' runat="server">
                                            <img style="border: 0px;" alt="" src="icons/update.gif" />
                                            <asp:Label ID="Label8" runat="server" Text="<%$ Resources:Resource, Insert %>"></asp:Label>
                                        </asp:LinkButton>
                                        <asp:LinkButton ID="UpdateLinkButton" CommandName="UpdateEdited" CausesValidation="false"
                                            Visible='<%# grdReportList.EditIndexes.Count > 0 %>' runat="server">
                                            <img style="border: 0px;" alt="" src="icons/update.gif" />
                                            <asp:Label ID="Label6" runat="server" Text="<%$ Resources:Resource, Update %>"></asp:Label>
                                        </asp:LinkButton>
                                        <asp:LinkButton ID="CancelLinkButton" CommandName="CancelAll" CausesValidation="false"
                                            Visible='<%# grdReportList.EditIndexes.Count > 0 || grdReportList.MasterTableView.IsItemInserted %>'
                                            runat="server">
                                            <img style="border: 0px;" alt="" src="icons/cancel.gif" />
                                            <asp:Label ID="Label7" runat="server" Text="<%$ Resources:Resource, Cancel %>"></asp:Label>
                                        </asp:LinkButton>--%>
                                    </td>
                                    <td align="right">
                                        <asp:LinkButton ID="RefreshReportButton" OnClientClick="RefreshReportButton_Click();" CausesValidation="false"
                                            ToolTip="<%$ Resources:Resource, Refresh %>" runat="server">
                                            <img style="border: 0px;" alt="" src="" />
                                            <asp:Label ID="Label2" runat="server" Text="<%$ Resources:Resource, Refresh %>"></asp:Label>
                                        </asp:LinkButton>
                                    </td>
                                </tr>
                            </table>
                            
                        </CommandItemTemplate>
                        <Columns>
                            <telerik:GridClientSelectColumn DataType="System.Boolean" UniqueName="Selected">
                                <HeaderStyle width="5%" horizontalalign="Center" />
                                <ItemStyle width="5%" horizontalalign="Center" />
                            </telerik:GridClientSelectColumn>
                            <telerik:GridBoundColumn DataField="ReportId" DataType="System.Int32" HeaderText="ReportId" UniqueName="ReportId" Display="False" >
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn DataField="ReportName" HeaderText="<%$ Resources:Resource, ReportName %>" UniqueName="ReportName">
								<HeaderStyle width="20%" horizontalalign="Left" />
								<ItemStyle width="20%" wrap="True" horizontalalign="Left" />								
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn DataField="ReportDescription" HeaderText="<%$ Resources:Resource, ReportDescription %>" UniqueName="ReportDescription">
								<HeaderStyle width="20%" horizontalalign="Left" />
								<ItemStyle width="20%" horizontalalign="Left" />
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn DataField="ReportTypeLabel" HeaderText="<%$ Resources:Resource, ReportType %>" UniqueName="ReportTypeLabel" ReadOnly="True">
								<HeaderStyle width="10%" horizontalalign="Left" />
								<ItemStyle width="10%" horizontalalign="Left" />
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn DataField="ReportType" UniqueName="ReportType" Visible="true" Display="false" ReadOnly="True"></telerik:GridBoundColumn>
                            <telerik:GridBoundColumn DataField="ReportCreatedDate" HeaderText="<%$ Resources:Resource, CreationDate %>" UniqueName="CreationDate" ReadOnly="True">
								<HeaderStyle width="15%" horizontalalign="Left" />
								<ItemStyle width="15%" wrap="False" horizontalalign="Left" />
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn DataField="ReportModifiedDate" HeaderText="<%$ Resources:Resource, LastModificationDate %>"  UniqueName="LastModificationDate" ReadOnly="True">
								<HeaderStyle width="15%" horizontalalign="Left" />
								<ItemStyle width="15%" wrap="False" horizontalalign="Left" />
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn DataField="ReportIsDeleted" HeaderText="Deleted"  UniqueName="ReportIsDeleted" Display="False" DataType="System.Boolean" ReadOnly="True"></telerik:GridBoundColumn>
                            <telerik:GridEditCommandColumn EditImageUrl="~/icons/edit.gif" UpdateImageUrl="~/icons/update.gif" CancelImageUrl="~/icons/cancel.gif" ButtonType="ImageButton" EditText="<%$ Resources:Resource, Edit %>" UpdateText="<%$ Resources:Resource, Update %>" CancelText="<%$ Resources:Resource, Cancel %>">
								<HeaderStyle width="5%" horizontalalign="Center" />
								<ItemStyle width="5%" horizontalalign="Center" />
                            </telerik:GridEditCommandColumn>
                        </Columns>                       
						<EditFormSettings>
							<EditColumn UniqueName="EditCommandColumn1">
							</EditColumn>
						</EditFormSettings>
                    </MasterTableView>                    
                    <ClientSettings>
                        <Scrolling AllowScroll="True" UseStaticHeaders="True" />
						<Selecting AllowRowSelect="True" />
                    </ClientSettings>                    
					<SortingSettings SortedAscToolTip="Click here to sort" SortedDescToolTip="Click here to sort" />
                </telerik:RadGrid>
                
        </div>    
		
		<div style="clear: both; display: none; background: White; width: 1px; height: 1px;">
			<iframe id="DownloadReportFrame" src="" width="100%" height="100%" frameborder="0" visible="true" runat="server" class="xlsPopUp"></iframe>
		</div>
    
    </telerik:RadAjaxPanel>
</asp:Content>
